<?php
// -- Include the required data and requirements for this page
include("templates/headers/inc.php");

// Include the JS file
$js_files = array("js/pages/home.js");

// Metadata informations of this page
$page_title = "Home - My Quiz";
$page_slug	= "home";

// Get website config
$site_config = $dbh->prepare("SELECT * FROM config WHERE config_name IN ('website_name','website_tagline','ads_code')");
$site_config->execute();

$config_array = array();

while($config = $site_config->fetch(PDO::FETCH_ASSOC)) {
	$config_array[$config["config_name"]] = $config["config_value"];
}

$website_name = $config_array["website_name"];
$website_tagline = $config_array["website_tagline"];
$ads_code = $config_array["ads_code"];

// -- General checks and redirects
// If we have a session, redirect !
if(!$_SESSION || !isset($_SESSION["USER_ID"])) {
	header("Location: index.php?action=need_log_in");
	exit;
}

$user_id = $_SESSION["USER_ID"];

// Check if user exists...
$quiz_sql = $dbh->prepare("	SELECT *
							FROM quiz
							WHERE user_id = :user_id
							");
					
$quiz_sql->bindParam(':user_id', $user_id);
$quiz_sql->execute();

	
// -- Include the header template
include("templates/headers/global_header.php");
?>

<?php
if($ads_code != "") {
?>
<div class="row">
	<div class="col-md-12">
		<?php
		echo $ads_code;
		?>
	</div>
</div>
<?php
}	
?>

<div class="row">

	<div class="inner-container">
		<center>
			<a class="btn btn-primary btn-create-quiz" href="create-quiz.php"><i class="em em-computer"></i> Create a Quiz</a>
			<?php
			if($_SESSION["RANK"] == 1) {	
			?>
			<a class="btn btn-danger btn-admin-area" href="admin.php"><i class="em em-closed_lock_with_key"></i> Admin Area</a>
			<?php
			}
			?>
		</center>
		<br />		
		<div class="quiz_list_container">
			<?php
			if($quiz_sql->rowCount() == 0) {
			?>
			<div class="alert alert-danger alert-center">
				You didn't create any quiz yet <i class="em em-anguished"></i>
			</div>
			<?php
			} else {
			?>
			<table class="table table-striped table-quizzes">
				<tr>
					<th>Quiz</th>
					<th>Participants</th>
					<th>Actions</th>
				</tr>
				<?php
				// Count total quiz for this user
				$user_id = intval($user_id);
				$total_quiz  = $dbh->query("SELECT COUNT(id) as rows FROM quiz WHERE user_id = $user_id")->fetch(PDO::FETCH_OBJ);
			
				// Pagination
				$perpage = 15;
				$posts  = $total_quiz->rows;
				$pages  = ceil($posts / $perpage);
				
				$get_pages = isset($_GET['page']) ? $_GET['page'] : 1;
				
				$data = array(
	
					'options' => array(
						'default'   => 1,
						'min_range' => 1,
						'max_range' => $pages
						)
				);
		
				$number = trim($get_pages);
				$number = filter_var($number, FILTER_VALIDATE_INT, $data);
				$range  = $perpage * ($number - 1);
		
				$prev = $number - 1;
				$next = $number + 1;
					
				// Get list of all quiz
				$quiz_query = $dbh->prepare("SELECT * FROM quiz WHERE user_id = :user_id ORDER BY created_at DESC LIMIT :limit, :perpage");
				$quiz_query->bindParam(":user_id", $user_id);
				$quiz_query->bindParam(':perpage', $perpage, PDO::PARAM_INT);
				$quiz_query->bindParam(':limit', $range, PDO::PARAM_INT);
				$quiz_query->execute();
					
				while($quiz = $quiz_query->fetch(PDO::FETCH_ASSOC)) {
					
					$cur_quiz_id = $quiz["id"];
					
					// Count the number of participatings on this quiz
					$nb_part_query = $dbh->prepare("SELECT id FROM participation WHERE quiz_id = :quiz_id");
					$nb_part_query->bindParam(":quiz_id", $cur_quiz_id);
					$nb_part_query->execute();
					
					$nb_parts = $nb_part_query->rowCount();
				?>
				<tr class="quiz-line" data-id="<?php echo $quiz["unique_id"]; ?>">
					<td class="align-left">
						<span class="q-title"><?php echo ucfirst(htmlspecialchars($quiz["title"])); ?></span>
						<br />
						<a class="btn btn-primary btn-sm btn-copy-link" data-clipboard-text="<?php echo URL ?>/quiz.php?id=<?php echo $quiz["unique_id"]; ?>"><i class="fas fa-copy"></i> Copy Quiz Link</a>
					</td>
					<?php
					if($nb_parts > 0) {
					?>
					<td>
						<a class="check_quiz_friends" href="friends.php?quiz_id=<?php echo $quiz["unique_id"]; ?>"><?php echo $nb_parts; ?></a>
					</td>
					<?php
					} else {
					?>
					<td><?php echo $nb_parts; ?></td>
					<?php
					}
					?>
					<td><a href="" class="btn btn-danger btn-delete btn-home-delete btn-sm" data-id="<?php echo $quiz["unique_id"]; ?>"><i class="fas fa-times"></i></a></td>
				</tr>
				<?php
				}	
				?>
			</table>
			<?php
			if($posts > 0) {
				if($pages > 1) {	
				?>
				<div class="pagination">
				<?php	
					echo "<div class='page-list'>";
	
					# first page
					if($number <= 1)
						echo "<span>&laquo; prev</span> | <a href=\"?page=$next\">next &raquo;</a>";
					
					# last page
					else if($number >= $pages)
						echo "<a href=\"?page=$prev\">&laquo; prev</a> | <span>next &raquo;</span>";
					
					# in range
					else
						echo "<a href=\"?page=$prev\">&laquo; prev</a> | <a href=\"?page=$next\">next &raquo;</a>";
	
					echo "</div>";
				?>
				</div>
				<?php
				}
			}	
			?>
			<?php
			}
			?>
		</div>
	</div>
					
</div>

<?php
// -- Include the footer template
include("templates/footers/global_footer.php");	
?>